//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.22 Page 315
//Title: Mean heat capacity
//===================================================

model Ex7_22

//=============
//Parameter Section
parameter Real x2(unit = "%") = 20 "Mole percent of alcohol";
parameter Real T1(unit = "K") = 323 "Initial temperature";
parameter Real T2(unit = "K") = 298 "Final temperature";
parameter Real Cp_1(unit = "J/kg K") = 4.18*10^3 "Heat capacity of water";
parameter Real Cp_2(unit = "J/kg K") = 2.58*10^3 "Heat capacity of ethanol";    
                                   //Given as 2.51*10^3 J/kg K in question, 2.58*10^3 J/kg K is used in calculation
parameter Real delta_H3(unit = "J/mol") = -758 "Heat of mixing at 298 K";
parameter Real delta_H(unit = "J/mol") = -415 "Heat of mixing at 323 K";
parameter Real M1(unit = "g/mol") = 18 "Molar mass of water";
parameter Real M2(unit = "g/mol") = 46 "Molar mass of ethanol";

//=============
//Variable Section
Real n2(unit = "mol") "Moles of ethanol";
Real n1(unit = "mol") "Moles of water";
Real delta_H1(unit = "J") "Enthalpy of cooling water from 323 K to 298 K";
Real delta_H2(unit = "J") "Enthalpy of cooling ethanol from 323 K to 298 K";
Real Cpm(unit = "J/mol K") "Mean specific heat of solution";

//============
//Equation Section
equation
n2 = x2/100;
n1 = 1-n2;
//Step 1 :0.8 mole of water is cooled from 323 K to 298 K
delta_H1 = (n1*M1*(Cp_1/10^3)*(T2-T1));  
//Step 2 :0.2 mole of ethanol is cooled from 323 K to 298 K
delta_H2 = (n2*M2*(Cp_2/10^3)*(T2-T1));
//Step 3 : 0.8 mol water and 0.2 mol of ethanol at 298 K are mixed together
//Step 4 : 20 % ethanol-water solution is heated to 323 K
delta_H = delta_H1+delta_H2+delta_H3+(Cpm*(T1-T2));

end Ex7_22;

//===================================================
 
