//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.12 Page 374
//Title: Van Laar constants
//===================================================

model Ex8_12


//============
//Parameter Section
parameter Real x1_p(unit = "%") = 46.1 "Mole per cent of component A";
parameter Real P(unit = "kPa") = 101.3 "Pressure of the azeotrope";
parameter Real T(unit = "K") = 345 "Temperature of the azeotrope";
parameter Real P1s(unit = "kPa") = 84.8 "Vapour pressure of A";
parameter Real P2s(unit = "kPa") = 78.2 "Vapour pressure of B";

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of A";
Real x2(unit = "-") "Mole fraction of B";
Real gamma1(unit = "-") "Activity coefficient of A";
Real gamma2(unit = "-") "Activity coefficient of B";
Real A(unit = "-") "Van Laar constant";
Real B(unit = "-") "Van Laar constant";

//============
//Equation Section
equation
x1 = x1_p/100;
x2 = 1-x1;
gamma1 = P/P1s;   //Using Eqn. 8.71 pg no. 371
gamma2 = P/P2s;
A = log(gamma1)*(1+((x2*log(gamma2)/(x1*log(gamma1)))))^2;    //Using Eqn. 8.69  pg no. 370
B = log(gamma2)*(1+((x1*log(gamma1)/(x2*log(gamma2)))))^2;

end Ex8_12;

//===================================================
