//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.13 Page 374
//Title: Activity coefficients
//===================================================

model Ex8_13


//============
//Parameter Section
parameter Real x2_p1(unit = "%") = 44.8 "Mole per cent of ethanol";
parameter Real P(unit = "kPa") = 101.3 "Pressure of the azeotrope";
parameter Real T(unit = "K") = 341.4 "Boiling point";
parameter Real P1s(unit = "kPa") = 68.9 "Vapour pressure of benzene";
parameter Real P2s(unit = "kPa") = 67.4 "Vapour pressure of ethanol";
parameter Real x2_p2(unit = "%") = 10 "Mole per cent of ethanol";

//============
//Variable Section
Real x1_1(unit = "-") "Mole fraction of benzene";
Real x2_1(unit = "-") "Mole fraction of ethanol";
Real gamma1_1(unit = "-") "Activity coefficient of benzene";
Real gamma2_1(unit = "-") "Activity coefficient of ethanol";
Real A(unit = "-") "Van Laar constant";
Real B(unit = "-") "Van Laar constant";
Real x1_2(unit = "-") "Mole fraction of benzene";
Real x2_2(unit = "-") "Mole fraction of ethanol";
Real gamma1_2(unit = "-") "Activity coefficient of benzene for 10% alcohol solution";
Real gamma2_2(unit = "-") "Activity coefficient of ethanol for 10% alcohol solution";


//============
//Equation Section
equation
x2_1 = x2_p1/100;
x1_1 = 1-x2_1;
gamma1_1 = P/P1s;    //Using Eqn. 8.71 pg no. 371
gamma2_1 = P/P2s;
A = log(gamma1_1)*(1+((x2_1*log(gamma2_1)/(x1_1*log(gamma1_1)))))^2;    //Using Eqn. 8.69  pg no. 370
B = log(gamma2_1)*(1+((x1_1*log(gamma1_1)/(x2_1*log(gamma2_1)))))^2;
x2_2 = x2_p2/100;
x1_2 = 1-x2_2;
log(gamma1_2) = (A*x2_2^2)/(((A/B)*x1_2)+x2_2)^2;   //Van Laar Equation
log(gamma2_2) = (B*x1_2^2)/((x1_2+((B/A)*x2_2)))^2;

end Ex8_13;

//===================================================
