//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.14 Page 375
//Title: Vapour composition
//===================================================

model Ex8_14

//============
//Parameter Section
parameter Real x2_p1(unit = "%") = 58.5 "Mole per cent of hydrazine";
parameter Real P(unit = "kPa") = 101.3 "Pressure of the azeotrope";
parameter Real T(unit = "K") = 393 "Temperature of the azeotrope";
parameter Real alpha(unit = "-") = 1.6 "Relative volatility of water with reference to hydrazine";
parameter Real P2s(unit = "kPa") = 124.76 "Vapour pressure of hydrazine";
parameter Real x2_p2(unit = "%") = 20 "Mole per cent of hydrazine";

//============
//Variable Section
Real P1s(unit = "kPa") "Vapour pressure of water";
Real x1_1(unit = "-") "Mole fraction of water";
Real x2_1(unit = "-") "Mole fraction of hydrazine";
Real gamma1_1(unit = "-") "Activity coefficient of water";
Real gamma2_1(unit = "-") "Activity coefficient of hydrazine";
Real A(unit = "-") "Van Laar constant";
Real B(unit = "-") "Van Laar constant";
Real x1_2(unit = "-") "Mole fraction of water";
Real x2_2(unit = "-") "Mole fraction of hydrazine";
Real gamma1_2(unit = "-") "Activity coefficient of water for 20% hydrazine solution";
Real gamma2_2(unit = "-") "Activity coefficient of hydrazine for 20% hydrazine solution";
Real y1(unit = "-") "Vapour composition of water";
Real y2(unit = "-") "Vapour composition of hydrazine";

//=============
//Equation Section
equation
x2_1 = x2_p1/100;
x1_1 = 1-x2_1;
P1s = alpha*P2s;
gamma1_1 = P/P1s;    //Using Eqn. 8.71 pg no. 371
gamma2_1 = P/P2s;
A = log(gamma1_1)*(1+((x2_1*log(gamma2_1)/(x1_1*log(gamma1_1)))))^2;    //Using Eqn. 8.69  pg no. 370
B = log(gamma2_1)*(1+((x1_1*log(gamma1_1)/(x2_1*log(gamma2_1)))))^2;
x2_2 = x2_p2/100;
x1_2 = 1-x2_2;
log(gamma1_2) = (A*x2_2^2)/(((A/B)*x1_2)+x2_2)^2;   //Van Laar Equation
log(gamma2_2) = (B*x1_2^2)/((x1_2+((B/A)*x2_2)))^2;
y1 = 1/(1+(gamma2_2*x2_2)/(gamma1_2*x1_2*alpha));
y2 = 1-y1;

end Ex8_14;

//===================================================
