//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.16 Page 377
//Title: Total pressure of the mixture
//===================================================

model Ex8_16

//============
//Parameter Section
parameter Real T(unit = "K") = 313 "Temperature of the mixture";
parameter Real P1(unit = "kPa") = 27 "Total pressure of 49.4% A solution";
parameter Real P1s(unit = "kpa") = 25 "Vapour pressure of pure A";
parameter Real P2s(unit = "kPa") = 24.3 "Vapour pressure of pure B";
parameter Real x1_p(unit = "%") = 12.5 "Mole per cent of A";

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of A";
Real x2(unit = "-") "Mole fraction of B";
Real gamma1_1(unit = "-") "Activity coefficient of A for 49.4 mol% A solution";
Real gamma2_1(unit = "-") "Activity coefficient of B for 49.4 mol% A solution";
Real gamma1_2(unit = "-") "Activity coefficient of A for 12.5% A solution";
Real gamma2_2(unit = "-") "Activity coefficient of B for 12.5% A solution";
Real P2(unit = "kPa") "Total pressure of 12.5% A solution";

//============
//Equation Section
equation
x1 = x1_p/100;
x2 = 1-x1;
gamma1_1 = P1/P1s;
gamma2_1 = P1/P2s;
log(gamma1_2) = 0.3632*x2^2;    //Deduced Eqn., Ref pg no. 378
log(gamma2_2) = 0.3632*x1^2;
P2 = (x1*gamma1_2*P1s)+(x2*gamma2_2*P2s);

end Ex8_16;

//===================================================
