//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.19 Page 380
//Title: Total pressure
//===================================================

model Ex8_19

//============
//Parameter Section
parameter Real T(unit = "K") = 353 "Temperature";
parameter Real P(unit = "kPa") = 91.2 "Pressure";
parameter Real p1(unit = "%") = 4.7 "Mole percent of isopropanol";
parameter Real P1s(unit = "kPa") = 91.11 "Vapour pressure of isopropanol";
parameter Real P2s(unit = "kPa") = 47.36 "Vapour pressure of water";
parameter Real A(unit = "-") = 2.47 "Van Laar constant";
parameter Real B(unit = "-") = 1.094 "Van Laar constant";


//============
//Variable Section
Real x1(unit = "-") "Mole fraction of isopropanol";
Real x2(unit = "-") "Mole fraction of water";
Real gamma1(unit = "-")"Activity coefficient of isopropanol";
Real gamma2(unit = "-")"Activity coefficient of water";
Real P1(unit = "kPa") "Pressure corresponding to equilibrium composition";

//============
//Equation Section
equation
x1 = p1/100;
x2 = 1-x1;
log(gamma1) = (A*x2^2)/((((A/B)*x1)+x2)^2);   //Van Laar Equation(Eqn. 8.68) pg no.370
log(gamma2) = (B*x1^2)/((x1+((B/A)*x2))^2);
P1 = (gamma1*x1*P1s)+(gamma2*x2*P2s);

//P1< P , Error must be caused due to air leak

end Ex8_19;

//===================================================
