//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.31 Page 406
//Title: Equilibrium temperature and composition of vapour
//===================================================

package Ex8_31

model Ex8_31_a

//=============
//Parameter Section
parameter Real P(unit = "kPa") = 93.30 "Total pressure";
parameter Real T1(unit = "K") = 353 "Temperature";
parameter Real T2(unit = "K") = 373 "Temperature";
parameter Real P1s(unit = "kPa") = 47.98 "Vapour pressure of water at 353 K";
parameter Real P2s(unit = "kPa") = 2.67 "Vapour pressure of liquid at 353 K";
parameter Real P3s(unit = "kPa") = 101.3 "Vapour pressure of water at 373 K";
parameter Real P4s(unit = "kPa") = 5.33 "Vapour pressure of liquid at 373 K";

//============
//Variable Section
Real Ps_1(unit = "kPa") "Sum of vapour pressure at 353 K";
Real Ps_2(unit = "kPa") "Sum of vapour pressure at 373 K";
Real T(unit = "K") "Equilibrium temperature";

//============
//Equation Section
equation 
Ps_1 = P1s+P2s;
Ps_2 = P3s+P4s;
T = T1+((T2-T1)/(Ps_2-Ps_1)*(P-Ps_1));    //Interpolation

end Ex8_31_a;

//============

model Ex8_31_b

extends Ex8_31_a;

//=============
//Parameter Section
parameter Real P5s(unit = "kPa") = 88.5 "Vapour pressure of water at 368.2 K";
parameter Real P6s(unit = "kPa") = 4.8 "Vapour pressure of liquid at 368.2 K";


//============
//Variable Section
Real y(unit = "-") "Mole fraction of water in vapour";
Real p(unit = "%") "Water in vapour phase";

//=============
//Equation Section
equation 
y = P5s/P;
p = y*100;

end Ex8_31_b;

//============

end Ex8_31;

