//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.11 Page 445
//Title: Calculation of equilibrium constant
//===================================================

model Ex9_11

//N2(g) + 3H2(g) ----> 2NH3(g)

//============
//Parameter Section
parameter Real T(unit = "K") = 500 "Temperature";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of N2";
parameter Real b(unit = "-") = 3 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of NH3";
parameter Real phi1(unit = "J/mol K") = -177.5 "Gibbs energy function of N2";
parameter Real phi2(unit = "J/mol K") = -116.9 "Gibbs energy funcion of H2";
parameter Real phi3(unit = "J/mol K") = -176.9 "Gibbs energy funcion of NH3";
parameter Real delta_H1(unit = "J/mol") = 8669 "Heat of formation function of N2";
parameter Real delta_H2(unit = "J/mol") = 8468 "Heat of formation function of H2";
parameter Real delta_H3(unit = "J/mol") = 9920 "Heat of formation function of NH3";
parameter Real delta_H(unit = "J/mol") = -46100 "Enthalpy of formation of ammonia";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real phi_298(unit = "J/mol K") "Giauque function";
Real delta_G(unit = "J/mol") "Standard free energy of formation at 500 K";
Real K(unit = "-") "Equilibrium constant at 600 K";

//============
//Equation Section
equation
phi_298 = ((c*phi3)-(a*phi1)-(b*phi2))-(((c*delta_H3)-(a*delta_H1)-(b*delta_H2))/T);  //Using Eqn. 9.53 pg no.441
delta_G/T = phi_298+((c*delta_H)/T);    ////Using Eqn. 9.57 pg no. 443
-R*log(K) = delta_G/T;     //Using Eqn. 9.31 pg no. 433

end Ex9_11;

//===================================================
