//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.15 Page 451
//Title: Fractional dissociation of steam
//===================================================

package Ex9_15

//CO(g)+H2O(g) ----> CO2(g)+H2(g)

model Ex9_15_a

//============
//Parameter Section
parameter Real n_CO(unit = "mol") = 1 "Mole of carbon monoxide";
parameter Real n_H2O(unit = "mol") = 1 "Mole of water vapour";
parameter Real K(unit = "-") = 1 "Equilibrium constant";
parameter Real T(unit = "K")  = 1100 "Temperature";
parameter Real P(unit = "bar") = 1 "Pressure";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of H2O";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of CO2";
parameter Real d(unit = "-") = 1 "Stoichiometric coefficient of H2";

//============
//Variable Section
Real n(unit = "mol") "Total moles";
Real nu(unit = "-") "Sum of stoichiometric numbers";
Real K_phi(unit = "-") "Equilibrium constant in terms of fugaciy coefficient";
Real Ky(unit = "-") "Equilibrium constant in terms of composition";
Real epsilon1(unit = "-") "Extent of the reaction";
Real z1(unit = "%") "Percentage conversion of steam";


//=============
//Equation Section
equation
n = n_CO+n_H2O;
nu = d+c-a-b;
K_phi = 1;    //Ideal behaviour is assumed
Ky = (K/K_phi)*(1/P^nu);    //Using Eqn. 9.65 pg no. 451
Ky = ((c*epsilon1)^c*(d*epsilon1)^d*(n+(nu*epsilon1))^(-nu))/((n_CO-(a*epsilon1))^a*(n_H2O-(b*epsilon1))^b);   
                                        //Mole fraction in terms of extent of the rxn
z1 = (b*epsilon1)/n_H2O*100;

end Ex9_15_a;

//============

model Ex9_15_b

extends Ex9_15_a;

//=============
//Parameter Section
parameter Real n_N2(unit = "mol") = 2 "Moles of nitrogen";

//============
//Variable Section
Real epsilon2(unit = "-") "Extent of the reaction";
Real z2(unit = "%") "Percentage conversion of steam with 2 mol N2 in reactant";


//=============
//Equation Section
equation
Ky = ((c*epsilon2)^c*(d*epsilon2)^d*(n+(nu*epsilon2))^(-nu))/((n_CO-(a*epsilon2))^a*(n_H2O-(b*epsilon2))^b);
                       //Mole fraction in terms of extent of the rxn
z2 = (b*epsilon2)/n_H2O*100;

end Ex9_15_b;

//==============

//Converion reamins the same

end Ex9_15;

