//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.18 Page 455
//Title: Presence of excess of reactants
//================================================

package Ex9_18

//CO(g)+H2O(g) ----> CO2(g)+H2(g)

model Ex9_18_a

//============
//Parameter Section
parameter Real n_H2O(unit = "mol") = 1 "Mole of steam";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of carbon monoxide";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of steam";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of carbon dioxide";
parameter Real d(unit = "-") = 1 "Stoichiometric coefficient of hydrogen";
parameter Real T(unit = "K")  = 1100 "Temperature";
parameter Real P(unit = "bar") = 1 "Pressure";
parameter Real K(unit = "-") = 1 "Equilibrium constant of the reaction";
parameter Real n_CO(unit = "mol") = 2 "Moles of carbon monoxide supplied"; //100% excess of stoichiometry


//============
//Variable Section
Real n(unit = "mol") "Total moles";
Real nu(unit = "-") "Sum of stoichiometric numbers";
Real epsilon1(unit = "-") "Extent of reaction in 100% excess of CO";
Real z1(unit = "%") "Percentage conversion of steam in 100% excess of CO";

//============
//Equation Section
equation
n = n_CO+n_H2O;
nu = c+d-a-b;
((c*epsilon1)^c*(d*epsilon1)^d*(n+(nu*epsilon1))^(-nu))/((n_CO-(a*epsilon1))^a*(n_H2O-(b*epsilon1))^b) = K;
z1 = (b*epsilon1)/n_H2O*100;

end Ex9_18_a;

//============

model Ex9_18_b

extends Ex9_18_a;


//============
//Parameter Section
parameter Real n2_CO(unit = "mol") = 0.5 "Moles of carbon monoxide supplied"; //50% of theoretical requirement


//============
//Variable Section
Real n2(unit = "mol") "Total moles";
Real epsilon2(unit = "-") "Extent of reaction in 50% of CO";
Real z2(unit = "%") "Percentage conversion of steam in 50% of CO";

//============
//Equation Section
equation
n2 = n2_CO+n_H2O;
((c*epsilon2)^c*(d*epsilon2)^d*(n+(nu*epsilon2))^(-nu))/((n2_CO-(a*epsilon2))^a*(n_H2O-(b*epsilon2))^b) = K;
z2 = (b*epsilon2)/n_H2O*100;

end Ex9_18_b;

//============

end Ex9_18;
