//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.22 Page 458
//Title: Composition of gases leaving the reactor
//================================================

model Ex9_22

//(1/2)N2+(3/2)H2 ----> NH3

//============
//Parameter Section
parameter Real pa(unit = "%") = 20 "Moles of nitrogen in gas mixture";
parameter Real pb(unit = "%") = 60 "Moles of hydrogen in gas mixture";
parameter Real pd(unit = "%") = 20 "Moles of inerts in gas mixture";
parameter Real a(unit = "-") = 1/2 "Stoichiometric coefficient of N2";
parameter Real b(unit = "-") = 3/2 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of NH3";
parameter Real P(unit = "bar") = 50 "Pressure";
parameter Real Kp(unit = "-") = 1.25/10^2 "Equilibrium constant in terms of fugacity";

//============
//Variable Section
Real n(unit = "mol") "Moles of initial gas mixture";
Real na(unit = "mol") "Moles of nitrogen";
Real nb(unit = "mol") "Moles of hydrogen";
Real nd(unit = "mol") "Moles of inerts";
Real nu(unit = "-") "Sum of stoichiometric coefficients";
Real Ky(unit = "-") "Equilibrium constant in terms of composition";
Real epsilon(unit = "-") "Extent of reaction ";
Real na_e(unit = "%") "Percent of nitrogen in exit";
Real nb_e(unit = "%") "Percent of hydrogen in exit";
Real nc_e(unit = "%") "Percent of ammonia in exit";
Real nd_e(unit = "%") "Percent of inerts in exit";

//============
//Equation Section
equation
n = 100;    //Basis
na = (pa/100)*n; 
nb = (pb/100)*n; 
nd = (pd/100)*n; 
nu = c-a-b;
Ky = Kp*(1/P^nu);   ////Ideal gas, so kphi = 1
Ky = ((c*epsilon)^c*(n+(nu*epsilon))^(-nu))/((na-(a*epsilon))^a*(nb-(b*epsilon))^b);
na_e = (na-(a*epsilon))/(n+(nu*epsilon))*100;   //Mole percentage
nb_e = (nb-(b*epsilon))/(n+(nu*epsilon))*100;
nc_e = (c*epsilon)/(n+(nu*epsilon))*100;
nd_e = (n-na_e-nb_e-nc_e);

end Ex9_22;

//================================================
