//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.24 Page 463
//Title: Calculation of decomposition pressure and temperature
//================================================

model Ex9_24

//============
//Parameter Section
parameter Real T1(unit = "K") = 1000 "Temperature 1";
parameter Real p2(unit = "bar") = 1 "Pressure 2";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real p1(unit = "bar") "Decomposition pressure at 1000 K";
Real T2(start = T1, unit = "K") "Decomposition temperature at 1 bar";
Real K1(unit = "-") "Equilibrium constant at 1000 K";
Real K2(unit = "-") "Equilibrium constant at 1 bar";
Real delta_G1(unit = "J") "Gibbs free energy at 1000 K";
Real delta_G2(unit = "J") "Gibbs free energy at 1 bar";

//============
//Equation Section
equation
delta_G1 = (1.8856*10^5)-(243.42*T1)+(11.8478*T1*log(T1))-(3.1045/10^3*T1^2)+(1.7271/10^6*T1^3)-(4.1784*10^5/T1);
K1 = exp(-(delta_G1)/(R*T1));
p1 = K1;   //Using Eqn. 9.75 p. 462
p2 = K2;
K2 = exp(-(delta_G2)/(R*T2));
delta_G2 = (1.8856*10^5)-(243.42*T2)+(11.8478*T2*log(T2))-(3.1045/10^3*T2^2)+(1.7271/10^6*T2^3)-(4.1784*10^5/T2);

//delta_G2 value tends to zero.

end Ex9_24;

//================================================
