//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.26 Page 464
//Title: Calculation of weight of metallic iron produced
//================================================

model Ex9_26

//============
//Parameter Section
parameter Real p_CO(unit = "%") = 20 "Moles of carbon monoxide";
parameter Real p_N2(unit = "%") = 80 "Moles of nitrogen";
parameter Real K(unit = "-") = 0.403 "Equilibrium constant";
parameter Real T(unit = "K")  = 1200 "Temperature";
parameter Real P(unit = "atm") = 1 "Pressure";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of CO2";
parameter Real T1(unit = "K") = 273 "Normal temperature";
parameter Real V1(unit = "m^3") = 100 "Volume of gas admitted";
parameter Real T1(unit = "K") = 273 "Standard temperature";
parameter Real nV(unit = "m^3/kmol") = 22.4 "Molar volume at STP";
parameter Real M(unit = "g/mol") = 55.8 "Molecular mass of iron";

//============
//Variable Section
Real n(unit = "mol") "Moles of gas entering";
Real epsilon(unit = "-") "Extent of the reaction";
Real n_Fe(unit = "mol") "Moles of iron produced per 100 mol of initial gas";
Real V2(unit = "m^3") "Equivalent volume of 100 mol of gas mixture";
Real m_Fe(unit = "kg") "Mass of iron produced per 100 m^3 of gas";

//============
//Equation Section
equation
n = 100;    //Basis
//Activity of solid components are taken as unity
epsilon/(p_CO-epsilon) = K;   //K = y_CO2/y_CO
n_Fe = epsilon;
V2 = (n*nV/10^3)*(T/T1);
m_Fe = ((n_Fe*M*V1)/V2)/10^3;   //Converting g to kg

end Ex9_26;

//================================================
