//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.27 Page 467
//Title: Composition of components at equilibrium
//===================================================

model Ex9_27

//1. CH4+H2O ----> CO+3H2
//2. CO+H2O ----> CO2+H2

//============
//Parameter Section
parameter Real n_CH4(unit = "mol") = 1 "Mole of methane";
parameter Real n_H2O(unit = "moles") = 5 "Moles of steam";
parameter Real T(unit = "K") = 850 "Temperature";
parameter Real P(unit = "bar") = 1 "Pressure";
parameter Real K1(unit = "-") = 0.574 "Equilibrium constant of reaction 1";
parameter Real K2(unit = "-") = 2.21 "Equilibrium constant of reaction 2";

//============
//Variable Section
Real nu1(unit = "-") "Sum of stoichiometric numbers of reaction 1";
Real nu2(unit = "-") "Sum of stoichiometric numbers of reaction 2";
Real Ky1(unit = "-") "Equilibrium constan in terms of composition for rxn 1 ";
Real Ky2(unit = "-") "Equilibrium constan in terms of composition for rxn 2 ";
Real epsilon1(unit = "-") "Extent of reaction for rxn 1";
Real epsilon2(unit = "-") "Extent of reaction for rxn 2";
Real y_CH4(unit = "-") "Mole fraction of methane";
Real y_H2O(unit = "-") "Mole fraction of steam";
Real y_CO(unit = "-") "Mole fraction of carbon monoxide";
Real y_H2(unit = "-") "Mole fraction of hydrogen";
Real y_CO2(unit = "-") "Mole fraction of carbon dioxide";

//============
//Equation Section
equation
nu1 = 2;
nu2 = 0;
Ky1 = K1*(1/P^nu1);
Ky2 = K2*(1/P^nu2);
Ky1 = ((epsilon1-epsilon2)*((3*epsilon1)+epsilon2)^3)/((1-epsilon1)*(5-epsilon1-epsilon2)*(6+(2*epsilon1))^2);
Ky2 = (epsilon2*((3*epsilon1)+epsilon2))/((epsilon1-epsilon2)*(5-epsilon1-epsilon2));
y_CH4 = (1-epsilon1)/(6+(2*epsilon1));
y_H2O = (5-epsilon1-epsilon2)/(6+(2*epsilon1));
y_CO = (epsilon1-epsilon2)/(6+(2*epsilon1));
y_H2 = ((3*epsilon1)+epsilon2)/(6+(2*epsilon1));
y_CO2 = epsilon2/(6+(2*epsilon1));

end Ex9_27;

//===================================================
