//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.7 Page 442
//Title: Calculation of equilibrium constant
//===================================================

model Ex9_7

//============
//Parameter Section
parameter Real T1(unit = "K") = 298 "Initial temperature";
parameter Real delta_H3(unit = "J/mol") = -46100 "Standard heat of formation of ammonia";
parameter Real delta_G3(unit = "J/mol") = -16500 "Standard free energy of formation of ammonia";
parameter Real T(unit = "K") = 500 "Final temperature";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of N2";
parameter Real b(unit = "-") = 3 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of NH3";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real delta_G(unit = "J/mol") "Standard free energy of reaction";
Real delta_H(unit = "J/mol") "Standard heat of reaction";
Real K1(unit = "-") "Eqilibrium constant at 298 K";
Real K(unit = "-") "Eqilibrium constant at 500 K";

//============
//Equation Section
equation
//N2(g)+3H2(g) ----> 2NH3(g)
delta_G = (c*delta_G3);    //From Eqn. 9.50 pg no. 440
delta_G = -R*T1*log(K1);    //Free energy of formation of elements are zero
delta_H = c*delta_H3;     //Assumed to be constant within the temperature range involved
log(K/K1)= -(delta_H/R)*((1/T)-(1/T1));

end Ex9_7;

//===================================================
