//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.3 Page 8
//Title: To find height from ground and kinetic energy
//===================================================

model Ex1_3

//============
//Parameter Section
parameter Real m(unit =  "kg") = 10 "Mass of the body";
parameter Real PE(unit = "kJ")  = 1.5 "Potential energy of the body";
parameter Real u(unit = "m/s") = 50 "Velocity of the body";
parameter Real g(unit = "m/s^2") = 9.8067 "Acceleration due to gravity";

//============
//Variable Section
Real z(unit = "m") "Height of the body from the ground";
Real KE(unit = "kJ") "Kinetic energy of the body";

//=============
//Equation Section
equation
(PE*10^3)=m*g*z;    //Converting J to kJ, Using Eqn. 1.8, p 8 
KE=(1/2*m*u^2)/10^3;   //Using Eqn. 1.9, p 9

end Ex1_3;

//===================================================
