//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.4 Page 9
//Title: Power developed in a man
//===================================================

model Ex1_4

//============
//Parameter Section
parameter Real F(unit = "N") = 600 "Weight of the man";
parameter Real t(unit = "min") = 2 "Time taken for climbing up a staircase";
parameter Real n(unit = "-") = 20 "Number of stairs";
parameter Real h(unit = "m") = 0.18 "Height of the stairs";

//=============
//Variable Section
Real d(unit = "m") "Total vertical displacement";
Real W(unit = "J") "Work done";
Real P(unit = "W") "Power developed in a man";

//=============
//Equation Section
equation
d=n*h;
W=F*d;
P=W/(t*60);   

end Ex1_4;

//===================================================
