//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.6 Page 10
//Title: Work done by the gas
//===================================================

model Ex1_6

//Library Section
extends Modelica.Constants;

//============
//Parameter Section
parameter Real d(unit = "m") = 0.5 "Diameter of spherical balloon";
parameter Real IP(unit = "bar") = 1 "Initial pressure inside the balloon";
parameter Real FP(unit = "bar") = 5 "Final pressure inside the balloon";

//============
//Variable Section 
Real W(unit = "J") "Work done by the gas";

//=============
//Equation Section

equation
/* Given pressure varies linearly with diameter. P/D = 2*10^5 from initial conditions.Since final pressure is 5*10^5 N/m^2 final diameter would be 2.5 m. Final expression after integration is given below */

W = (10^5)*(pi/4)*(2.5^4 - 0.5^4);

end Ex1_6;

//===================================================
