//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.11 Page 36
//Title: Work done by the turbine
//===================================================

model Ex2_11

//===========
//Parameter Section
parameter Real m(unit = "kg/hr") = 1650 "Mass of steam used";
parameter Real H1(unit = "kJ/kg") = 3200 "Enthalpy of super heated steam at 1368 kPa and 645 K";
parameter Real H2(unit = "kJ/kg") = 2690 "Enthalpy of sat. steam at 137 kPa";
 
//============
//Variable Section
Real Ws(unit = "kJ/kg") "Shaft work";
Real W(unit = "J/s") "Work done in W";
Real P(unit = "hp") "Theoretical horse power developed by turbine";

//============
//Equation Section
equation
/*Process is adiabatic, Q = 0. Assuming inlet and discharge of the turbine are at the same level delta_Z = 0.
Feed and discharge velocities being equal, delta_u^2 = 0 */
Ws = H1-H2;   //Refer equation 2.13 (Pg no. 36)
W = (Ws*10^3)*(m/3600);   //Converting to Watts
P = W/745.7;    // 1 hp = 745.7 W

end Ex2_11;

//===================================================
