//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.12 Page 36
//Title: To determine the heat added to the system
//===================================================

model Ex2_12

//=============
//Parameter Section
parameter Real zB(unit = "-") = 0.5 "Mole percent of benzene in the feed";
parameter Real zT(unit = "-") = 0.5 "Mole percent of toluene in the feed";
parameter Real v(unit = "-") = 0.6 "Mole percent of feed vapourised";
parameter Real Hf(unit = "kJ/mol") = 5 "Enthalpy of feed";
parameter Real Hd(unit = "kJ/mol") = 30 "Enthalpy of distillate";
parameter Real Hw(unit = "kJ/mol") = 2 "Enthalpy of residue";
parameter Real D(unit = "mol") = 1 "Moles of distillate";    // Basis

//============
//Variable Section
Real F(unit = "mol") "Moles of feed";
Real W(unit = "mol") "Moles of residue";
Real delta_H(unit = "kJ") "Change in enthalpy";

//============
//Equation Section
equation
F = D/v;
W = F-D;
// By eqn. 2.14 (Refer Pg no. 36) delta_H = Q- Ws . Since no work is exchanged, delta_H = Q
delta_H = (D*Hd)+(W*Hw)-(F*Hf); 

end Ex2_12;

//===================================================
