//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.13 Page 37
//Title: Temperature of water delivered to a second storage tank
//===================================================

model Ex2_13

//============
//Parameter Section
parameter Real T1(unit = "K") = 368 "Temperature of water in tank 1";
parameter Real q(unit = "m^3/hr") = 25 "Volumetric flow rate of water of tank 1";
parameter Real P(unit = "hp") = 2 "Power supplied by the motor";
parameter Real Q(unit = "kJ/min") = -42000 "Heat given out in heat exchanger";
parameter Real delta_Z(unit = "m") = 20 "Elevation of second tank above first tank";
parameter Real H0(unit = "kJ") = 0 "Enthalpy of water at 273 K";
parameter Real T0(unit = "K") = 273 "Standard temperature";
parameter Real Cp(unit = "kJ/kg.K") =4.2 "Specific heat of water";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of water";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//============
//Variable Section
Real m(unit = "kg/hr") "Mass flow rate of water";
Real Ws(unit = "kJ/kg") "Work done per kg of water pumped";
Real Qs(unit = "kJ/kg") "Heat given out per kg of fluid";
Real delta_PE(unit = "kJ/kg") "Change in potential energy";
Real delta_H(unit = "kJ/kg") "Change in enthalpy";
Real H1(unit = "kJ/kg") "Enthalpy in first tank";
Real H2(unit = "kJ/kg") "Enthalpy in second tank";
Real T2(unit = "K") "Temperature of water at second storage tank";

//============
//Equation Section
equation
m = q*rho;
Ws = -(P*(745.7/10^3)*(3600/m));    // Converting hp to kW and kg/hr to kg/s
Qs = Q*(60/m);    // Converting kg/hr to kg/min
delta_PE = g*delta_Z/10^3 ; 
delta_H = Qs-Ws-delta_PE;   //Using eq. 2.13 (pg no.36)
H1 = Cp*(T1-T0);    //Enthalpy at T0 is zero
H2 = delta_H+H1;
T2 = (H2/Cp)+T0;
end Ex2_13;

//===================================================
