//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.14 Page 38
//Title: Change in enthalpy
//===================================================

package Ex2_14

model Ex2_14_a

//============
//Parameter Section
parameter Real D1(unit = "mm") = 25 "Internal diameter of insulated pipe";
parameter Real u1(unit = "m/s") = 10 "Upstream velocity";
parameter Real D2(unit = "mm") = 50 "Downstram diameter of pipe";

//============
//Variable Section
Real u2(unit = "m/s") "Downstream velocity";
Real delta_H(unit = "J/kg") "Change in enthalpy";

//=============
//Equation Section
equation
u2 = (D1^2/D2^2)*u1;
delta_H = (1/2)*(u1^2-u2^2);

end Ex2_14_a;

//============

model Ex2_14_b

extends Ex2_14_a;

//============
//Variable Section
Real delta_Hmax(unit = "J/kg") "Max. enthalpy change for sudden enlargement in pipe";

//============
//Equation Section
equation
delta_Hmax = (1/2)*u1^2;

end Ex2_14_b;

//============

end Ex2_14;

//===================================================
