//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.2 Page 27
//Title: Change in internal energy, work and heat
//===================================================

model Ex2_2

//============
//Parameter Section
parameter Real P(unit = "kPa") = 101 "Pressure inside the cylinder";
parameter Real T(unit = "K") = 298 "Temperature inside the cylinder";
parameter Real n(unit = "-") = 2 "Moles of iron reacted";
parameter Real Q(unit = "kJ") = -831.08 "Heat liberated";
parameter Real R(unit = "J/mol.K") = 8.314 "Ideal gas constant";
parameter Real delta_n(unit = "-") = -1.5 "Moles of oxygen reacted";

//============
//Variable section
Real W(unit = "J") "Work done by the system";
Real delta_U(unit = "J") "Change in internal energy";

//============
//Equation Section
equation
W = (delta_n*R*T); //P*(delta_V)=delta_n*R*T     W=P*(delta_V)
delta_U =(Q*10^3)-W;  //delta_U = Q-W

end Ex2_2;

//===================================================
