//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.7 Page 32
//Title: Change in internal energy and enthalpy
//===================================================

model Ex2_7

//============
//Parameter Section 
parameter Real n(unit = "kmol") = 1 "Moles of water";
parameter Real T(unit = "K") = 373 "Temperature";
parameter Real P(unit = "kPa") = 101.3 "Pressure";
parameter Real n_Vl(unit = "m^3/kmol") = 1.04/10^3 "Specific volume of liquid" ;
parameter Real n_Vv(unit = "m^3/kmol") = 1.675 "Specific volume of vapour";
parameter Real Q(unit = "kJ") = 1030 "Heat added to the system";

//============
//Variable Section
Real W(unit = "kJ") "Work done by the system";
Real delta_U(unit = "kJ") "Change in internal energy";
Real delta_H(unit = "kJ") "Change  in enthalpy";

//============
//Equation Section
equation
W = P*(n_Vv-n_Vl)*n;    //Expansion Work
delta_U = Q-W;        //First law of thermodynamics
delta_H = Q;    //Constant P process, delta_H = delta_U + P*delta_V  = Q

end Ex2_7;

//===================================================
