//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.8 Page 33
//Title: Internal energy of sat. liquid & Internal energy and enthalpy of sat. vapour 
//===================================================

model Ex2_8

//============
//Parameter Section
parameter Real T(unit = "K") = 233 "Temperature";
parameter Real VP(unit = "kPa") = 1005 "Vapour pressure";
parameter Real nVl(unit = "m^3/kg") = 0.0009 "Specific volume of sat. liquid";
parameter Real Hl(unit = "kJ/kg") = 0 "Enthalpy of sat. liquid";
parameter Real delta_Hv(unit = " kJ/kg") = 320.5 "Latent heat of vapourisation";
parameter Real nVv(unit = "m^3/kg") = 0.0382 "Specific volume of sat. vapour";

//============
//Variable section
Real Ul(unit = "kJ/kg") "Internal energy of sat. liquid";
Real Hv(unit = "kJ/kg") "Enthalpy of sat. vapour";
Real Uv(unit = "kJ/kg") "Internal energy of sat. vapour";

//============
//Equation Section
equation
Ul = Hl - (VP*nVl);
Hv = Hl + delta_Hv;
Uv = Hv - (VP*nVv);

end Ex2_8;

//===================================================
