//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.12 Page 74
//Title: Heat of reaction
//===================================================

model Ex3_12

//============
//Parameter Section
parameter Real T1(unit = "K") = 300 "Temperature 1";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of A";
parameter Real b(unit = "-") = 3 "Stoichiometric coefficient of B";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of C";
parameter Real delta_H300(unit = "kJ") = -200 "Heat of reaction at 300 K";
parameter Real Cp_b(unit = "kJ/mol K") = 0.03 "Molar heat capacity at constant pressure of B";
parameter Real Cp_c(unit = "kJ/mol K") = 0.1 "Molar heat capacity at constant pressure of C";
parameter Real T2(unit = "K") = 500 "'Temperature 2";

//=============
//Variable Section
Real n(unit = "mol") "Mole of A";
Real delta_H1(unit = "kJ") "Enthalpy change for cooling reactants from 500 K to 300 K";
Real delta_H2(unit = "kJ") "Enthalpy change for heating products from 300 K to 500 K";
Real delta_H500(unit = "kJ") "Heat of reaction at 500 K";

//=============
//Equation Section
equation
n = 1;  //Basis
//Cp for A = (-1.7*10^-3)+(3.4*10^-4*T)
delta_H1 = a*(-1.7/10^3)*(T1-T2)+((3.4/(2*10^4))*(T1^2-T2^2))+(b*Cp_b*(T1-T2)); //Cooling of reactants to 300 K
delta_H2 = c*Cp_c*(T2-T1);    //Heating of product to 500 K
delta_H500 = delta_H1+delta_H300+delta_H2;

end Ex3_12;

//===================================================
