//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.14 Page 76
//Title: Standard heat of reaction at 773 K
//===================================================

model Ex3_14

//=============
//Parameter Section
parameter Real delta_Ht(unit = "kJ") = -164.987 "Standard heat of reaction at 298 K";
parameter Real T(unit = "K") = 298 "Standard temperature";
parameter Real T1(unit = "K") = 773 "Reaction temperature";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO2";
parameter Real b(unit = "-") = 4 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of H2O";
parameter Real d(unit = "-") = 1 "Stoichiometric coefficient of CH4";
parameter Real alpha[4] = {26.75, 26.88, 29.16, 13.41} "Constant alpha in heat capacity equation";
parameter Real beta[4] = {42.26/10^3, 4.35/10^3, 14.49/10^3, 77.03/10^3} "Constant beta in heat capacity equation";
parameter Real gamma[4] = {-14.25/10^6, -0.33/10^6, -2.02/10^6, -18.74/10^6 } "Constant gamma in heat capacity equation";

//============
//Variable Section
Real del_alpha "Change in heat capacity constant alpha";
Real del_beta "Change in heat capacity constant beta";
Real del_gamma "Change in heat capacity constant gamma";
Real delta_H(unit = "J") "Constant in equation";
Real delta_Ht1(unit = "kJ") "Standard heat of reaction at 773 K";

//============
//Equation Section
equation
del_alpha = (c*alpha[3])+(d*alpha[4])-(a*alpha[1])-(b*alpha[2]);
del_beta = (c*beta[3])+(d*beta[4])-(a*beta[1])-(b*beta[2]);
del_gamma = (c*gamma[3])+(d*gamma[4])-(a*gamma[1])-(b*gamma[2]);
(delta_Ht*10^3) = delta_H+(del_alpha*T)+(del_beta/2*T^2)+(del_gamma/3*T^3);   //Eqn. 3.54 pg no.74 Converting kJ to J
delta_Ht1 = (delta_H+(del_alpha*T1)+(del_beta/2*T1^2)+(del_gamma/3*T1^3))/10^3; //Converting J to kJ

end Ex3_14;

//===================================================
