//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.15 Page 76
//Title: Heat added or removed in a reaction
//===================================================

model Ex3_15

//=============
//Parameter Section
parameter Real A(unit = "%") = 100 "Percentage of excess air";
parameter Real T1(unit = "K") = 400 "Temperature of reactant";
parameter Real T2(unit = "K") = 600 "Temperature of product";
parameter Real T(unit = "K") = 298 "Reference temperature";
parameter Real Cp_a(unit  ="J/mol K") = 29.10 "Mean molal specific heat of CO ";
parameter Real Cp_b(unit  ="J/mol K") = 41.45 "Mean molal specific heat of CO2 ";
parameter Real Cp_c(unit  ="J/mol K") = 29.70 "Mean molal specific heat of O2 ";
parameter Real Cp_d(unit  ="J/mol K") = 29.10 "Mean molal specific heat of N2 ";
parameter Real delta_Ho(unit = "kJ/mol") = -283.028 "Standard heat of reaction at 298 K";   //Reaction is exothermic so minus is included


//============
//Variable Section
Real na_f(unit = "mol") "Moles of CO fed";
Real nc_t(unit = "mol") "Theoretical requirement of O2";
Real nc_a(unit = "mol") "O2 supplied";
Real na(unit = "mol") "Moles of CO in product stream";
Real nb(unit = "mol") "Moles of CO2 in product stream";
Real nc(unit = "mol") "Moles of O2 in product stream";
Real nd(unit = "mol") "Moles of N2";
Real delta_H1(unit = "kJ") "Enthalpy of cooling reactants from 373 K to 298 K";
Real delta_H2(unit = "kJ") "Enthalpy of heating products from 298 K to 573 K";
Real delta_H(unit = "kJ") "Enthalpy change during the reaction";
String Heat;

//============
//Equation Section
equation
//CO+(1/2)O2 ---> CO2
na_f = 1;   //Basis
nc_t = 0.5;   //From stoichiometry
nc_a = nc_t*(1+(A/100));
na = 0;   //CO completely burnt
nb = 1;
nc = (nc_a-nc_t);
nd = na_f*79/21;   //Composition of nitrogen and oxygen in air is 79% and 21%
delta_H1 = (((na_f*Cp_a)+(nc_a*Cp_c)+(nd*Cp_d))*(T-T1))/10^3;
delta_H2 = (((na*Cp_a)+(nb*Cp_b)+(nc*Cp_c)+(nd*Cp_d))*(T2-T))/10^3;
delta_H = (delta_H1+delta_Ho+delta_H2);

if delta_H >= 0 then
Heat = "Heat Added";
else
Heat = "Heat Removed";
end if;

Modelica.Utilities.Streams.print(Heat);

end Ex3_15;
