//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.16 Page 77
//Title: Theoretical flame temperature
//===================================================

model Ex3_16
//=============
//Parameter Section
parameter Real A(unit = "%") = 100 "Percentage of excess air";
parameter Real T1(unit = "K") = 373 "Temperature of reactant";
parameter Real T(unit = "K") = 298 "Reference temperature";
parameter Real Cp_a(unit  ="J/mol K") = 29.23 "Mean molal specific heat of CO ";
parameter Real Cp_b(unit  ="J/mol K") = 53.59 "Mean molal specific heat of CO2 ";
parameter Real Cp_c(unit  ="J/mol K") = 34.83 "Mean molal specific heat of O2 ";
parameter Real Cp_d(unit  ="J/mol K") = 33.03 "Mean molal specific heat of N2 ";
parameter Real delta_Ho(unit = "kJ/mol") = -283.178 "Standard heat of reaction at 298 K";

//============
//Variable Section
Real na_f(unit = "mol") "Moles of CO fed";
Real nc_t(unit = "mol") "Theoretical requirement of O2";
Real nc_a(unit = "mol") "O2 supplied";
Real na(unit = "mol") "Moles of CO in product stream";
Real nb(unit = "mol") "Moles of CO2 in product stream";
Real nc(unit = "mol") "Moles of O2 in product stream";
Real nd(unit = "mol") "Moles of N2";
Real T2(unit = "K") "Theoretical flame temperature";
Real delta_H1(unit = "J") "Enthalpy of cooling reactants from 373 K to 298 K";
Real delta_H(unit = "J") "Enthalpy change during the reaction";

//============
//Equation Section
equation
//CO+(1/2)O2 ---> CO2
na_f = 1;   //Basis
nc_t = 0.5;   //From stoichiometry
nc_a = nc_t*(1+(A/100));
na = 0;   //CO completely burnt
nb = 1;
nc = (nc_a-nc_t);
nd = na_f*79/21;   //Composition of nitrogen and oxygen in air is 79% and 21%
delta_H1 = ((na_f*Cp_a)+(nc_a*Cp_c)+(nd*Cp_d))*(T-T1);
delta_H = 0;    //Adiabatic process
delta_H = (delta_H1+(delta_Ho*10^3)+(((na*Cp_a)+(nb*Cp_b)+(nc*Cp_c)+(nd*Cp_d))*(T2-T)));   //Using Eqn. 3.55 pg no. 77

end Ex3_16;
