//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.3 Page 57
//Title: Heat and work effects in various processes
//===================================================

model Ex3_3

//============
//Parameter Section
parameter Real T1(unit = "K") = 300 "Initial temperature of the gas";
parameter Real P1(unit = "bar") = 1 "Initial pressure of the gas";
parameter Real P2(unit = "bar") = 2 "Pressure after heating the gas";
parameter Real Cp(unit = "kJ/kmol K") = 29.3 "Heat capacity at constant pressure";
parameter Real R(unit = "kJ/kmol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real Cv(unit = "kJ/kmol K") "Heat capacity at constant volume";
Real T2(unit = "K") "Temperature after heating the gas";
Real Q1(unit  = "kJ/kmol") "Heat supplied in const. volume process";
Real gamma(unit = "-") "Specific heat ratio";
Real T3(unit = "K") "Final temperature of adiabatic process";
Real W2(unit = "kJ/kmol") "Work done during adiabatic process";
Real Q3(unit = "kJ/kmol") "Heat supplied in const. pressure process";
Real delta_U(unit = "kJ/kmol") "Change in internal energy during const. pressure process";
Real W3(unit = "kJ/kmol") "Work done during const. pressure process";

//=============
//Equation Section
equation
Cv = Cp-R;
T2=(P2/P1)*T1;
//Work done for const. volume process is zero
Q1 = Cv*(T2-T1);      
gamma = Cp/Cv;
T3 = T2*((P1/P2)^((gamma-1)/gamma));
//Heat supplied for adiabatic process is zero
W2 = Cv*(T2-T3);    
Q3 = Cp*(T1-T3);
delta_U = Cv*(T1-T3);
W3 = Q3-delta_U;

end Ex3_3;

//Answer may slightly vary due to rounding off values

//===================================================
