//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.10 Page 106
//Title: Change in entropy
//===================================================

model Ex4_10

//==============
//Parameter Section
parameter Real m1(unit = "kg") = 10 "Mass of hot water";
parameter Real T1(unit = "K") = 375 "Temperature of hot water";
parameter Real m2(unit = "kg") = 30 "Mass of cold water";
parameter Real T2(unit = "K") = 275 "Temperature of cold water";
parameter Real Cp(unit = "kJ/kg K") = 4.2 "Specific heat of water";

//==============
//Variable Section
Real T(unit = "K") "Final temperature of the system";
Real delta_S1(unit = "kJ/K") "Change in entropy of hot water";
Real delta_S2(unit = "kJ/K") "Change in entropy of cold water";
Real delta_S(unit = "kJ/K") "Total change in entropy";

//=============
//Equation Section
equation
m1*(T1-T)  = m2*(T-T2);
delta_S1 = m1*Cp*log(T/T1);       //Equation for adiabatic mixing process
delta_S2 = m2*Cp*log(T/T2);
delta_S = delta_S1+delta_S2;

end Ex4_10;

//===================================================
