//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.11 Page 106
//Title: Change in entropy
//===================================================

model Ex4_11

//==============
//Parameter Section
parameter Real m1(unit = "kg") = 35 "Mass of steel casting";
parameter Real T1(unit = "K") = 725 "Temperature of steel casting";
parameter Real m2(unit = "kg") = 150 "Mass of oil";
parameter Real T2(unit = "K") = 275 "Temperature of oil";
parameter Real Cp1(unit = "kJ/kg K") = 0.88 "Specific heat of steel";
parameter Real Cp2(unit = "kJ/kg K") = 2.5 "Specific heat of oil";

//==============
//Variable Section
Real T(unit = "K") "Final temperature of the system";
Real delta_S1(unit = "kJ/K") "Change in entropy of steel";
Real delta_S2(unit = "kJ/K") "Change in entropy of oil";
Real delta_S(unit = "kJ/K") "Total chahnge in entropy";

//=============
//Equation Section
equation
m1*Cp1*(T1-T)  = m2*Cp2*(T-T2);
delta_S1 = m1*Cp1*log(T/T1);       //Equation for adiabatic mixing process
delta_S2 = m2*Cp2*log(T/T2);
delta_S = delta_S1+delta_S2;

end Ex4_11;

//===================================================
