//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.18 Page 115
//Title: Change in entropy of the system
//===================================================

model Ex4_18

//============
//Parameter Section
parameter Real Thi(unit = "K") = 500 "Inlet temperature of oil";
parameter Real mh(unit = "kg/h") = 5000 "Mass flow rate of oil";
parameter Real Tci(unit = "K") = 295 "Inlet temperature of cold water";
parameter Real T(unit = "K") = 10 "Approach temperature";
parameter Real Cph(unit = "kJ/kg K") = 3.2 "Specific heat of oil";
parameter Real Cpc(unit = "kJ/kg K") = 4.2 "Specific heat of water";

//============
//Variable Section
Real mc(unit = "kg/hr") "Mass flow rate of cold water";
Real delta_S_h(unit = "kJ/K") "Change in entropy of oil";
Real delta_S_c(unit = "kJ/K") "Change in entropy of water";
Real delta_S(unit = "kJ/K") "Total change in entropy";

//============
//Equation Section
equation
mc*Cpc*((Thi-T)-Tci) = mh*Cph*(Thi-(Tci+T));
delta_S_h = mh*Cph*log((Tci+T)/Thi);
delta_S_c = mc*Cpc*log((Thi-T)/Tci);
delta_S = delta_S_h+delta_S_c;

end Ex4_18;

//===================================================
