//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.19 Page 116
//Title: Change in entropy of the system
//===================================================

model Ex4_19

//============
//Parameter Section
parameter Real delta_S1(unit = "kJ/K") = -26.25 "Change in entropy of steel";    //Value from Ex4_11
parameter Real delta_S2(unit = "kJ/K") = 43.90 "Change in entropy of oil";    //Value from Ex4_11
parameter Real To(unit = "K") = 275 "Temperature of the surrounding";    //Value from Ex4_11

//===========
//Variable Section
Real delta_S(unit = "kJ/K") "Total change in entropy";
Real W(unit = "kJ") "Loss in capacity of work";

//============
//Equation Section
equation
delta_S = delta_S1+delta_S2;
W = To*delta_S;   //Using Eqn. 4.53, pg no. 116

end Ex4_19;

//===================================================
