//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.2 Page 100
//Title: Thermal efficiency and work done by the engine
//===================================================

model Ex4_2

//=============
//Parameter Section
parameter Real T1(unit = "K") = 600 "Temperature of source";
parameter Real Q(unit = "J") = 1000 "Heat transferred to an engine";
parameter Real T2(unit = "K") = 300 "Temperature of the sink";

//=============
//Variable Section
Real eta(unit = "-") "Efficiency of the Carnot engine";
Real W(unit = "J") "Work done by the engine";

//============
//Equation Section
equation
eta = (T1-T2)/T1;
W = (eta*Q);  

end Ex4_2;

//===================================================
