//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.22 Page 119
//Title: Absolute entropy of water vapour
//===================================================

model Ex4_22

//===========
//Parameter Section
parameter Real T1(unit = "K") = 473 "Temperature of water vapour";
parameter Real T2(unit = "K") = 373 "Boiling point of water";
parameter Real T3(unit = "K") = 273 "Base temperature";
parameter Real Cp1(unit = "kJ/kg K") = 4.2 "Average heat capacity of water";
parameter Real Cp2(unit = "kJ/kg K") = 1.9 "Specific heat of water vapour between 373 K and 473 K";
parameter Real delta_Hv(unit = "kJ/kg") = 2257 "Latent heat of vaporisation at 373 K";

//============
//Variable Section
Real S(unit = "kJ/kg K") "Absolute entropy";

//===========
//Equation Section
equation
S = ((Cp1*log(T2/T3))+(delta_Hv/T2)+(Cp2*log(T1/T2)));    //Expression after integration

end Ex4_22;
