//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.3 Page 100
//Title: Work and heat of refrigeration process
//===================================================

package Ex4_3

model Ex4_3_a

//===============
//Parameter Section
parameter Real m(unit = "kg") = 1 "Mass of water";
parameter Real T2(unit = "K") = 273 "Temperature inside refrigerator";
parameter Real T1(unit = "K") = 300 "Temperature of the surrounding";
parameter Real Q2(unit = "kJ/kg") = 334.11 "Latent heat of fusion of ice";

//===============
//Variable Section
Real W(unit = "kJ") "Minimum amount of work required";

//================
//Equation Section
equation
W = (Q2*((T1-T2)/T2));

end Ex4_3_a;

model Ex4_3_b

extends Ex4_3_a;

//=============
//Variable Section
Real Q1(unit = "kJ") "Heat given up to the surroundings";

//=============
//Equation Section
equation
Q1 = W+Q2;

end Ex4_3_b;

end Ex4_3;
