//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.4 Page 101
//Title: Coefficient of performance
//===================================================

model Ex4_4

//=============
//Parameter Section
parameter Real T1(unit = "K") = 300 "Temperature of the room";
parameter Real T2(unit = "K") = 270 "Temperature inside the refrigerator";
parameter Real COP(unit = "-") = 9.5 "Coefficient of performance claimed";

//===========
//Variable Section
Real COP_c(unit = "-") "Coefficient of performance of ideal cycle";
String Claim;

//============
//Equation Section
equation
COP_c = T2/(T1-T2);

if COP > COP_c then
Claim = "Unacceptable" ;
else
Claim = "Acceptable";
end if;

Modelica.Utilities.Streams.print(Claim);

end Ex4_4;

//===================================================
