//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.5 Page 101
//Title: Efficiency of the engine
//===================================================

model Ex4_5

//=============
//Parameter Section
parameter Real P(unit = "hp") = 4.5 "Power output of the engine";
parameter Real Q(unit = "kW") = 6.25 "Heat input to the engine";
parameter Real T1(unit = "K") = 1000 "Source Temperature ";
parameter Real T2(unit = "K") = 500 "Sink Temperature ";

//============
//Variable Section
Real W(unit = "W") "Work output of the proposed engine";
Real eta_c(unit = "-") "Efficiency of the proposed engine";
Real eta_i(unit  = "-") "Efficiency of the Carnot engine";
String Possibility;

//============
//Equation Section
equation
W = (P*745.7);    //Converting horse power to Watts
eta_c  = W/(Q*10^3);
eta_i = (T1-T2)/T1;

if eta_c > eta_i then
 Possibility = "Impossible";    //No engine can have efficiency greater than carnot engine
else
 Possibility = "Possible";
end if;

Modelica.Utilities.Streams.print(Possibility);

end Ex4_5;

//===================================================
