//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.1 Page 130
//Title: Pressure at the exit using Bernoulli's equation
//===================================================

model Ex5_1

extends Modelica.Constants;

//============
//Parameter Section
parameter Real u1(unit = "m/s") = 1 "Velocity at the entrance";
parameter Real d1(unit = "m") = 0.2 "Diameter at the entrance";
parameter Real d2(unit = "m") = 0.1 "Diameter at the exit";
parameter Real P1(unit = "kPa") = 105 "Pressure at the entrance";
parameter Real delta_Z(unit = "m") = 5 "Distance between entrance and exit";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of water";
parameter Real g(unit = "m^2/s") = 9.81 "Acceleration due to gravity";

//===========
//Variable Section
Real u2(unit = "m/s") "Velocity at the exit";
Real P2(unit = "kPa") "Pressure at the exit";

//============
//Equation Section
equation
(pi/4)*d1^2*u1 = (pi/4)*d2^2*u2;    //From equation of continuity
(u2^2-u1^2)/2 + g*delta_Z +((P2-P1)*10^3/rho) = 0;    //From Bernoulli's equation

end Ex5_1;

//===================================================
