//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.13 Page 150
//Title: Work requirement for compressor
//===================================================

model Ex5_13

//===========
//Parameter Section
parameter Real P1(unit = "kPa") = 100 "Pressure of sat. steam";
parameter Real P2(unit = "kPa") = 500 "Pressure of superheated steam";
parameter Real eta(unit = "-") = 0.8 "Compression efficiency";
//Data from steam tables
parameter Real T1(unit = "K") = 327.8 "Temperature of sat. steam";
parameter Real H1(unit = "kJ/kg") = 2675.5 "Enthalpy of sat. steam";
parameter Real S1(unit = "kJ/kg K") = 7.3594 "Entropy of sat. steam";
parameter Real T2(unit = "K") = 545.74 "Temperature of superheated steam";   //By interpolation
parameter Real H2(unit = "kJ/kg") = 3008 "Enthalpy of superheated steam";
parameter Real S2(unit = "kJ/kg K") = 7.3594 "Entropy of superheated steam";    //Isentropic compression S2=S1

//============
//Variable Section
Real delta_H(unit = "'kJ/kg") "Change in enthalpy";
Real Ws_i(unit = "kJ/kg") "Isentropic work";
Real Ws_a(unit = "kJ/kg") "Actual work";
Real delta_H_a(unit = "kJ/kg") "Actual change in enthalpy";
Real H2_a(unit = "kJ/kg") "Actual enthalpy of steam leaving the compressor";

//===========
//Equation Section
equation
delta_H = H2-H1;
Ws_i = -delta_H;    //From Eqn. 5.44 pg no. 144
Ws_a = Ws_i/eta;
delta_H_a = delta_H/eta;
H2_a = delta_H_a+H1;

//Temperature of exhaust steam is 586 K 

end Ex5_13;

//===================================================
