//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.18 Page 158
//Title: Vapour compression refrigeration
//===================================================

model Ex5_18

//===========
//Parameter Section
parameter Real r(unit = "ton") = 10 "Refrigeration capacity";
parameter Real T1(unit = "K") = 298 "Temperature in the condenser";
parameter Real T2(unit = "K") = 256 "Temperature in the evaporator";
parameter Real Ps1(unit = "bar") = 6.79 "Saturation pressure at 298 K";
parameter Real Ps2(unit = "bar") = 1.62 "Saturation pressure at 256 K";
parameter Real HA(unit = "kJ/kg")  = 181 "Enthalpy of sat. vapour at 256 K";
parameter Real HB(unit = "kJ/kg")  = 206 "Enthalpy of superheated vapour at 6.79 bar";
parameter Real HC(unit = "kJ/kg")  = 62 "Enthalpy of sat. liquid at 298 K";
parameter Real SA(unit  = "kJ/kg K") = 0.714 "Entropy of sat. vapour at 256 K";
parameter Real SC(unit  = "kJ/kg K") = 0.231 "Entropy of sat. liquid at 298 K";

//===========
//Variable Section
Real SD(unit = "kJ/kg K") "Entropy of mixture at 298 K";
Real HD(unit = "kJ/kg") "Enthalpy of mixture at 298 K";
Real COP(unit = "-") "Coefficient of performance";
Real m(unit = "kg/h") "Refrigerant circulation rate";

//===========
//Equation Section
equation
SD = SC;    //Expansion is reversible adiabatic process
HD = HA-T2*(SA-SD);
COP = (HA-HD)/((HB-HC)-(HA-HD));    //From Eqn. 5.64 pg no. 156
m = (12660*r)/(HA-HD);    //From Eqn. 5.63 pg no. 156 and 1 ton of refrigeration is equivalent to 12660 kJ/h

end Ex5_18;

//===================================================
