//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.2 Page 130
//Title: Quality of steam
//===================================================

model Ex5_2

//============
//Parameter Section
//Data from steam tables
parameter Real Hv(unit = "kJ/kg") = 2778 "Enthalpy of sat. vapour at 1000 kPa";
parameter Real Hl(unit = "kJ/kg") = 763 "Enthalpy of sat. liquid at 1000 Pa";
parameter Real H2(unit = "kJ/kg") = 2726 "Enthalpy of superheated steam at 398 K and 101.3 kPa";

//============
//Variable Section
Real x(unit = "-") "Fraction of steam that is liquid";
Real L(unit = "%") "Percentage of liquid in steam";

//============
//Equation Section
equation
//Assuming kinetic annd potential energy changes are negligible and Q and Ws are zero
H2 - (x*Hl+(1-x)*Hv) = 0;   //Reduced form of Eqn. 5.10 pg no. 128 
L = x*100;

end Ex5_2;

//===================================================
