//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.21 Page 165
//Title: Heat pumps
//===================================================

model Ex5_21

//==========
//Parameter Section
parameter Real T1(unit = "K") = 295 "Inside temperature";
parameter Real T2(unit = "K") = 275 "Outside temperature";
parameter Real eta(unit = "-") = 0.25 "Overall efficiency";
parameter Real Hc(unit = "kJ/mol") = 890.9 "Heat of combustion of fuel";
parameter Real e(unit = "-") = 0.33 "Efficiency of conversion of heat of combustion to electricity";
parameter Real Q1(unit = "MJ")  = 1000 "Heat to be delivered to the building";

//===========
//Variable Section
Real COP(unit = "-") "Coefficient of performance";
Real W(unit = "kJ") "Work required";
Real E(unit = "kJ") "Actual amount of electrical energy to be supplied";
Real H(unit = "kJ") "Heat energy required as heat of combustion";
Real n(unit = "kmol") "No. of moles of fuel burned";

//===========
//Equation Section
equation
COP = T1/(T1-T2);
W = (Q1*10^3)/COP;
E = W/eta;    
H = E/e;
n = H/(Hc*10^3);

end Ex5_21;

//===================================================
