//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.23 Page 170 
//Title: Air liquefaction
//===================================================

package Ex5_23

model Ex5_23_a

//===========
//Parameter Section
parameter Real P1(unit = "bar") = 120 "Pressure of gas leaving the compressor";
parameter Real T1(unit = "K") = 306 "Temperature of the gas leaving the cooler";
parameter Real HC(unit = "kJ/kg") = 516 "Enthalpy of gas at 306 K";
parameter Real P2(unit = "bar") = 2 "Pressure of gas leaving the separator";
parameter Real T2(unit = "K") = 292 "Temperature of gas leaving the heat exchanger";
parameter Real HA(unit = "kJ/kg") = 526 "Enthalpy of gas at 292 K";
parameter Real HF(unit = "kJ/kg") = 121 "Enthalpy of sat. liquid  at 2 bar";
parameter Real HG(unit = "kJ/kg") = 314 "Enthalpy of sat. vapour at 2 bar";

//===========
//Variable Section
Real x(unit = "-") "Fraction of the liquefied air";


//===========
//Equation Section
equation
x = ((HC-HA)/(HF-HA));

end Ex5_23_a;

//===========

model Ex5_23_b

extends Ex5_23_a;

//============
//Variable Section
Real HD(unit = "kJ/kg") "Enthalpy of air on the high pressure side of throttle valve";

//============
//Equation Section
equation 
(HC-HD) = (1-x)*(HA-HG);

//Temperature of the air is 167 K is determined from T-S diagram

end Ex5_23_b;

//==========

end Ex5_23;

//===================================================
