//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.24 Page 172
//Title: Rankine cycle
//===================================================

package Ex5_24

model Ex5_24_a

//=============
//Parameter Section
parameter Real P(unit = "MW") = 1 "Power of steam power plant";
parameter Real P2(unit = "kPa") = 2800 "Pressure of superheated steam";
parameter Real T2(unit = "K") = 598 "Temperature of superheated steam";
parameter Real P1(unit = "kPa") = 5 "Pressure afer expansion";
parameter Real eta_t(unit = "-") = 0.85 "Efficiency of isentropic turbine";
parameter Real eta_p(unit = "-") = 0.8 "Efficiency of isentropic pump efficiency";
parameter Real V(unit = "m^3/kg") = 1.005/10^3 "Specific volume of sat. liquid at 5 kPa";
parameter Real H1(unit = "kJ/kg") = 138 "Enthalpy of sat. liquid at 5 kPa";
parameter Real Hv(unit = "kJ/kg") = 2562 "Enthalpy of sat. vapour at 5 kPa";
parameter Real H3(unit = "kJ/kg") = 3063 "Enthalpy of superheated steam";
parameter Real S1(unit = "kJ/kg K") = 0.4764 "Entropy of sat. liquid at 5 kPa";
parameter Real Sv(unit = "kJ/kg K") = 8.3951 "Entropy of sat. vapour at 5 kPa";
parameter Real S3(unit = "kJ/kg K") = 6.6875 "Entropy of superheated steam";

//===========
//Variable Section
Real Ws(unit = "kJ/kg") "Work required by the pump";
Real H2(unit = "kJ/kg") "Enthalpy of water leaving the pump";
Real S4(unit = "kJ/kg K") "Entropy of steam leaving the turbine";
Real x(unit = "-") "Fraction of steam that is vapour";
Real H4(unit = "kJ/kg") "Enthalpy of steam leaving the turbine";
Real eta(unit = "%") "Efficiency of ideal Rankine cycle";

//===========
//Equation Section
equation
Ws = V*(P2-P1);
H2 = Ws+H1;
S4=S3;    //Isentropic expansion in turbine
S4 = S1+(x*(Sv-S1));
H4 = H1+(x*(Hv-H1));
eta = (((H3-H2)-(H4-H1))/(H3-H2))*100;    //From Eqn. 5.80 Ref. pg no. 171

end Ex5_24_a;

//============

model Ex5_24_b

extends Ex5_24_a;

//===========
//Variable Section
Real W(unit = "kJ/kg") "Actual work required by the pump";
Real H2a(unit = "kJ/kg") "Actual enthalpy of water leaving the pump";
Real Wt(unit = "kJ/kg") "Work output of the turbine in isentropic expansion";
Real Wta(unit = "kJ/kg") "Actual work output of the turbine";
Real H4a(unit = "kJ/kg") "Actual enthalpy of steam leaving the turbine";
Real eta_a(unit = "%") "Actual efficiency of the cycle";

//===========
//Equation Section
equation
W = Ws/eta_p;
H2a = H1+W;
Wt = H3-H4;
Wta = Wt*eta_t;
H4a = H3-Wta;
eta_a = (((H3-H2a)-(H4a-H1))/(H3-H2a))*100;

end Ex5_24_b;

//============

model Ex5_24_c

extends Ex5_24_b;

//============
//Variable Section
Real W_net(unit = "kJ/kg") "Net work output";
Real m(unit = "kg/h") "Steam production in boiler";

//============
//Equation Section
equation 
W_net = (eta_a/100)*(H3-H2a);
m = (P*3.6*10^6)/W_net;

end Ex5_24_c;

//===========

end Ex5_24;

//===================================================
