//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.26 Page 178
//Title: Regenerative cycle
//===================================================

model Ex5_26

//===========
//Parameter Section
parameter Real T3(unit = "K") = 598 "Temperature of steam entering the high-pressure turbine";
parameter Real P2(unit = "kPa") = 2800 "Pressure of steam entering the high-pressure turbine";
parameter Real P1(unit = "kPa") = 275 "Pressure of steam after expansion";
parameter Real T5(unit = "K") = 658 "Temperature of steam entring low-pressure turbine";
parameter Real P5(unit = "kPa") = 5 "Pressure of steam after expansion to condenser pressure";
parameter Real V(unit = "m^3/kg") = 1.07/10^3 "Specific volume of sat. liquid at 275 kPa";
parameter Real Hl_5(unit = "kJ/kg") = 138 "Enthalpy of sat. liquid at 5 kPa";
parameter Real Sl_5(unit = "kJ/kg K") = 0.4764 "Entropy of sat. liquid at 5 kPa";
parameter Real Hv_5(unit = "kJ/kg") = 2562 "Enthalpy of sat. vapour at 5 kPa";
parameter Real Sv_5(unit = "kJ/kg K") = 8.3951 "Entropy of sat. vapour at 5 kPa";
parameter Real Hl_4(unit = "kJ/kg") = 549 "Enthalpy of sat. liquid at 275 kPa";
parameter Real Sl_4(unit = "kJ/kg K") = 1.6408 "Entropy of sat. liquid at 275 kPa";
parameter Real Hv_4(unit = "kJ/kg") = 2721 "Enthalpy of sat. vapour at 275 kPa";
parameter Real Sv_4(unit = "kJ/kg K") = 7.0209 "Entropy of sat. vapour at 275 kPa";
parameter Real  H3(unit = "kJ/kg") = 3063  "'Enthalpy of superheated steam at 2800 kPa and 598 K";
parameter Real  S3(unit = "kJ/kg K") = 6.6875 "'Entropy of superheated steam at 2800 kPa and 598 K";

//===========
//Variable Section
Real m(unit = "-") "Fraction of steam extracted from the turbine";
Real S4(unit = "kJ/kg K") "Entropy of steam leaving the high-pressure turbine";
Real x4(unit = "-") "Fraction of steam leaving high-pressure turbine in vapour state";
Real H4(unit = "kJ/kg") "Enthalpy of steam leaving the high-pressure turbine";
Real Ws(unit = "kJ/kg") "Work input to the feed water pump";
Real H1(unit = "kJ/kg") "Enthalpy of water entering the pump";
Real H2(unit = "kJ/kg") "Enthalpy of water leaving the pump";
Real S5(unit = "kJ/kg K") "Entropy of steam entering the condenser";
Real x5(unit = "-") "Fraction of steam entering the condenser in vapour state";
Real H5(unit = "kJ/kg") "Enthalpy of steam entering the condenser";
Real eta(unit = "%") "Efficiency of the cycle";

//===========
//Equation Section
equation
S4 = S3;    //Isentropic expansion
S4 = Sl_4+(x4*(Sv_4-Sl_4));
H4 = Hl_4+(x4*(Hv_4-Hl_4));
m*(H4-Hl_4) = (1-m)*(Hl_4-Hl_5);
Ws = V*(P2-P1);
H1 = Hl_4;
H2 = H1+Ws;
S5 = S3;    //Isentropic expansion
S5 = Sl_5+(x5*(Sv_5-Sl_5));
H5 = Hl_5+(x5*(Hv_5-Hl_5));
eta = ((H3-H2)-((1-m)*(H5-Hl_5)))/(H3-H2)*100;    //Eqn 5.85 Ref pg no. 175

end Ex5_26;

//===================================================
