//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.27 Page 182
//Title: Otto cycle
//===================================================

package Ex5_27

model Ex5_27_a

//============
//Parameter Section
parameter Real r(unit = "-") = 8 "Compression ratio of Otto cycle";
parameter Real T1(unit = "K") = 290 "Temperature at the beginning of compression stroke";
parameter Real P1(unit = "kPa") = 100 "Pressure at the beginning of compression stroke";
parameter Real Q1(unit = "kJ/kg of air") = 450 "Heat transferred per cycle";
parameter Real Cp(unit = "kJ/kg K") = 1.005 "Specific heat of air at const. pressure";
parameter Real Cv(unit = "kJ/kg K") = 0.718 "Specific heat of air at const. volume";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
parameter Real m(unit = "kg") = 1 "Mass of air";
parameter Real M(unit = "kg/kmol") = 29 "Molecular weight of air";

//===========
//Variable Section
Real V1(unit = "m^3") "Volume of air";
Real V2(unit = "m^3") "Volume of air after compression";
Real gamma(unit = "-") "Ratio of specific heats";
Real T2(unit = "K") "Temperature of air after compression";
Real P2(unit = "kPa") "Pressure of air after compression";
Real V3(unit = "m^3") "Volume of air at state 3";
Real T3(unit = "K") "Temperature of air before expansion";
Real P3(unit = "kPa") "Pressure of air before expansion";
Real T4(unit = "K") "Temperature of air after expansion";
Real P4(unit = "kPa") "Pressure of air after expansion";
Real Q2(unit = "kJ/kg") "Heat rejected during const. volume process";

//==========
//Equation Section
equation
//Isentropic compression
V1 = ((m/M)*R*T1)/P1;   //Ideal gas law
//Constant volume heat addition
V2 = V1/r;
gamma = Cp/Cv;
T2 = T1*(r^(gamma-1));
P2 = P1*r^gamma;
V3 = V2;
//Isentropic expansion
Q1 = Cv*(T3-T2);
P3 = P2*(T3/T2);
//Constant volume heat rejection
T4 = T3/ r^(gamma-1);
P4 = P3/r^gamma;
Q2 = Cv*(T4-T1);

end Ex5_27_a;

//============

model Ex5_27_b

extends Ex5_27_a;

//===========
//Variable Section
Real eta(unit = "-") "Thermal efficiency of the cycle";

//===========
//Equation Section
equation 
eta = 1-(1/r)^(gamma-1);

end Ex5_27_b;

//============

model Ex5_27_c

extends Ex5_27_b;

//===========
//Variable Section
Real W(unit = "kJ/kg") "Work done by kg of air";

//===========
//Equation Section
equation 
W =  Q1-Q2;

end Ex5_27_c;

//============

model Ex5_27_d

extends Ex5_27_c;

//===========
//Variable Section
Real Pm(unit = "kPa") "Mean effective pressure";

//===========
//Equation Section
equation
Pm*(V1-V2) = W;

end Ex5_27_d;

//===========

end Ex5_27;
