//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.4 Page 132
//Title: Final temperature of steam in tank
//===================================================


model Ex5_4

//============
//Parameter Section
parameter Real P1(unit = "MPa") = 1.2 "Pressure of steam";
parameter Real T(unit = "K") = 673 "Temperature of steam";
parameter Real Hi(unit = "kJ/kg") = 3260.7 "Enthalpy of steam at 1.2 MPa and 673 K";

//============
//Variable Section
Real m1(unit = "kg") "Mass of the steam initially present in the tank";
Real me(unit = "kg") "Mass of the steam leaving the control volume";
Real U2(unit = "kJ/kg") "Internal energy of steam in the steam";

//============
//Equation Section
equation
m1 = 0;
me = 0;
//Q=Ws=0, no heat and no work exchanged
U2 = Hi;    //Using Eqn. 5.6a pg no. 131 

//Outlet temperature from steam table is 853 K

end Ex5_4;

//===================================================
