//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.5 Page 133
//Title: Mass of the refrigerant and heat transfer
//===================================================

package Ex5_5

model Ex5_5_a

//============
//Parameter Section
parameter Real V(unit = "m^3") = 0.1 "Volume of the tank";
parameter Real T1(unit = "K") = 283 "Temperature of refrigerant inside the tank";
parameter Real v(unit = "-") = 0.6 "Percent by mass of vapour in the tank";
parameter Real l(unit = "-") =  0.4 "Percent by mass of liquid in the tank";
parameter Real T2(unit = "K") =  403 "Temperature of refrigerant in the pipeline";
parameter Real P2(unit = "MPa") = 1 "Pressure of refrigerant in the pipeline";
parameter Real P3(unit = "MPa") = 1.017 "Final pressure in the tank";
parameter Real Ps1(unit = "kPa") = 415.8 "Saturation pressure at 283 K";
parameter Real Ts3(unit = "K") = 313 "Saturation temperature at 1.017 MPa";
parameter Real Vl1(unit = "m^3/kg") = 7.94/10^4 "Specific volume of sat. liquid at 283 K";
parameter Real Vv1(unit = "m^3/kg") = 4.945/10^2 "Specific volume of sat. liquid at 283 K";
parameter Real Vv3(unit = "m^3/kg") = 0.02 "Specific volume of sat. vapour at 313 K";

//============
//Variable Section
Real m1(unit = "kg") "Initial mass of material in tank";
Real m2(unit = "kg") "Final mass of material in tank";
Real mi(unit = "kg") "Mass of refrigerant admitted";

//============
//Equation Section
equation
(l*m1*Vl1)+(v*m1*Vv1) = V;
m2*Vv3 = V;
mi =m2-m1;

end Ex5_5_a;

model Ex5_5_b

extends Ex5_5_a;

//============
//Parameter Section
parameter Real Hl1(unit = "kJ'kg") = 213.58 "Enthalpy of sat. liquid at 283 K";
parameter Real Hv1(unit = "kJ/kg") = 404.23 "Enthalpy of sat. vapour at 283 K";
parameter Real Hv3(unit = "kJ/kg") = 419.821 "Enthalpy of sat. vapour at 313 K";
parameter Real Hv2(unit = "kJ/kg") = 514.69 "Enthalpy of superheated vapour at 403 K and 1 MPa";


//============
//Variable Section
Real Ul(unit = "kJ/kg") "Internal energy of sat. liquid at 283 K";
Real Uv(unit = "kJ/kg") "Internal energy of sat. vapour at 283 K";
Real U1(unit = "kJ/kg") "Internal energy of initial mass in the tank";
Real U2(unit = "kJ/kg") "Internal energy of final state ";
Real Hi(unit = "kJ/kg") "Enthalpy of refrigerant admitted into the tank";
Real Q(unit = "kJ") "Heat transferred";

//============
//Equation Section
equation 
Ul = Hl1 -(Ps1*Vl1);    // U = H-PV
Uv = Hv1 -(Ps1*Vv1);
U1 = (l*Ul)+(v*Uv);
U2 = Hv3-(P3*10^3*Vv3);
Hi = Hv2;   
Q = (m2*U2)-(m1*U1)-(mi*Hi);    //Reduced energy balance equation Pg no. 133

end Ex5_5_b;

end Ex5_5;

//===================================================
